/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.IVWTaskProcessLookup;
import filenet.vw.apps.taskman.IVWTaskServiceManager;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskProcessResult;
import filenet.vw.apps.taskman.VWTaskProcessStreamReader;
import filenet.vw.apps.taskman.VWTaskServiceManager;
import filenet.vw.apps.taskman.VWTaskServiceProperties;
import filenet.vw.base.VWConvertTwo;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.sysutils.VWJavaLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Date;

public class VWTaskProcessLauncher {
    private static Logger logger = Logger.getLogger("filenet.vw.apps.taskman");
    private static String m_className = VWTaskProcessLauncher.class.getName();

    private VWTaskProcessLauncher() {
    }

    public static VWTaskProcessResult exec(String command, String inputData, boolean wait, boolean asService, VWTaskBaseNode node) throws Exception {
        String method = "exec";
        if (asService && VWTaskProcessLauncher.useServiceManager(node)) {
            logger.fine(m_className, method, "Calling task service manager to execute command: " + command);
            return VWTaskProcessLauncher.getServiceManager(node).exec(new Util().encodeCommand(command), inputData, wait);
        }
        return VWTaskProcessLauncher.execImpl(command, inputData, wait);
    }

    protected static VWTaskProcessResult execImpl(String command, String inputData, boolean wait) throws Exception {
        String method = "execImpl";
        logger.fine(m_className, method, "");
        logger.fine(m_className, method, "Executing: " + command);
        Process process = Runtime.getRuntime().exec(command);
        if (wait) {
            return VWTaskProcessLauncher.getResult(process, inputData, null);
        }
        VWTaskProcessLauncher.closeStreams(process);
        return null;
    }

    public static VWTaskProcessResult exec(String[] cmdArray, String inputData, boolean wait, boolean asService, VWTaskBaseNode node) throws Exception {
        String method = "exec";
        if (node != null && asService && VWTaskProcessLauncher.useServiceManager(node)) {
            logger.fine(m_className, method, "Calling task service manager to execute command:");
            for (int i = 0; i < cmdArray.length; ++i) {
                logger.fine(m_className, method, cmdArray[i]);
                cmdArray[i] = new Util().encodeCommand(cmdArray[i]);
            }
            return VWTaskProcessLauncher.getServiceManager(node).exec(cmdArray, inputData, wait);
        }
        return VWTaskProcessLauncher.execImpl(cmdArray, inputData, wait);
    }

    protected static VWTaskProcessResult execImpl(String[] cmdArray, String inputData, boolean wait) throws Exception {
        String method = "execImpl";
        logger.fine(m_className, method, "");
        logger.fine(m_className, method, "Executing: ");
        for (int i = 0; i < cmdArray.length; ++i) {
            VWTaskCore.getInstance();
            if (VWTaskCore.isWindowsOS() && (cmdArray[i] == null || cmdArray[i].equals(""))) {
                cmdArray[i] = "\"\"";
            }
            logger.fine(m_className, method, cmdArray[i]);
        }
        Process process = Runtime.getRuntime().exec(cmdArray);
        if (wait) {
            return VWTaskProcessLauncher.getResult(process, inputData, null);
        }
        VWTaskProcessLauncher.closeStreams(process);
        return null;
    }

    public static VWTaskProcessResult launchJavaServer(ArrayList jArgs, String command, boolean useJavaw, String noWinExecPath, VWTaskBaseNode node) throws Exception {
        String serviceName;
        String method = "launchJavaServer";
        ArrayList<String> javaArgs = new ArrayList<String>(node.getVMFlags());
        if (jArgs != null) {
            javaArgs.addAll(jArgs);
        }
        if ((serviceName = node.getServiceName()) != null) {
            javaArgs.add("-Dfilenet.vw.base.logging.ServiceName=" + serviceName);
        }
        if (VWTaskProcessLauncher.useServiceManager(node)) {
            logger.fine(m_className, method, "Calling task service manager to execute java command: " + command);
            return VWTaskProcessLauncher.getServiceManager(node).launchJavaServer(node.getJREBinPath(), VWTaskProcessLauncher.getJavaArgsArray(javaArgs), new Util().encodeCommand(command), useJavaw, noWinExecPath, node);
        }
        return VWTaskProcessLauncher.launchJavaServerImpl(node.getJREBinPath(), VWTaskProcessLauncher.getJavaArgsArray(javaArgs), command, useJavaw, noWinExecPath, node);
    }

    protected static VWTaskProcessResult launchJavaServerImpl(String jreBin, String[] javaArgs, String command, boolean useJavaw, String noWinExecPath, IVWTaskProcessLookup lookupCallback) throws Exception {
        Process process = VWJavaLauncher.exec(jreBin, javaArgs, command, useJavaw, noWinExecPath);
        if (lookupCallback != null) {
            return VWTaskProcessLauncher.getResult(process, null, lookupCallback);
        }
        VWTaskProcessLauncher.closeStreams(process);
        return null;
    }

    public static VWTaskProcessResult launchJavaProcess(ArrayList jArgs, String command, boolean useJavaw, boolean wait, boolean redirectStreams, boolean asService, VWTaskBaseNode node) throws Exception {
        String serviceName;
        String jreBinPath;
        String method = "launchJavaProcess";
        ArrayList<String> javaArgs = new ArrayList<String>();
        String string = jreBinPath = node != null ? node.getJREBinPath() : null;
        if (jArgs != null) {
            javaArgs.addAll(jArgs);
        }
        if (node != null && (serviceName = node.getServiceName()) != null) {
            javaArgs.add("-Dfilenet.vw.base.logging.ServiceName=" + serviceName);
        }
        if (asService && VWTaskProcessLauncher.useServiceManager(node)) {
            logger.fine(m_className, method, "Calling task service manager to execute java command: " + command);
            return VWTaskProcessLauncher.getServiceManager(node).launchJavaProcess(jreBinPath, VWTaskProcessLauncher.getJavaArgsArray(javaArgs), new Util().encodeCommand(command), useJavaw, wait, redirectStreams);
        }
        return VWTaskProcessLauncher.launchJavaProcessImpl(jreBinPath, VWTaskProcessLauncher.getJavaArgsArray(javaArgs), command, useJavaw, wait, redirectStreams);
    }

    protected static VWTaskProcessResult launchJavaProcessImpl(String jreBin, String[] javaArgs, String command, boolean useJavaw, boolean wait, boolean redirectStreams) throws Exception {
        Process process = VWJavaLauncher.exec(jreBin, javaArgs, command, useJavaw, null);
        if (wait) {
            return VWTaskProcessLauncher.getResult(process, null, null, redirectStreams);
        }
        VWTaskProcessLauncher.closeStreams(process);
        return null;
    }

    private static String[] getJavaArgsArray(ArrayList args) {
        return args != null && args.size() > 0 ? args.toArray(new String[0]) : null;
    }

    private static void closeStreams(Process p) {
        try {
            p.getInputStream().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            p.getErrorStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static VWTaskProcessResult getResult(Process theProcess, String inputData, IVWTaskProcessLookup serverNode) throws Exception {
        return VWTaskProcessLauncher.getResult(theProcess, inputData, serverNode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VWTaskProcessResult getResult(Process theProcess, String inputData, IVWTaskProcessLookup serverNode, boolean redirectStreams) throws Exception {
        VWTaskProcessResult result;
        String method;
        block26: {
            method = "getResult";
            final Process process = theProcess;
            result = null;
            StringBuffer outputBuffer = new StringBuffer();
            StringBuffer errorBuffer = new StringBuffer();
            VWTaskProcessStreamReader outputReader = null;
            VWTaskProcessStreamReader errorReader = null;
            try {
                outputReader = new VWTaskProcessStreamReader(process.getInputStream(), outputBuffer, redirectStreams ? System.out : null);
                outputReader.start();
                errorReader = new VWTaskProcessStreamReader(process.getErrorStream(), errorBuffer, redirectStreams ? System.err : null);
                errorReader.start();
                if (inputData != null) {
                    OutputStream oStream = process.getOutputStream();
                    oStream.write(inputData.getBytes());
                    oStream.flush();
                    oStream.close();
                }
                if (serverNode != null) {
                    Runnable processRunnable = new Runnable(){

                        public void run() {
                            try {
                                process.waitFor();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    Thread processMonitor = new Thread(processRunnable);
                    processMonitor.start();
                    Object lookupResult = null;
                    while (lookupResult == null && processMonitor.isAlive()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        logger.fine(m_className, method, "Looking up server.");
                        lookupResult = serverNode.lookupTaskProcess();
                        if (lookupResult != null) {
                            logger.fine(m_className, method, "Found server.");
                            continue;
                        }
                        logger.fine(m_className, method, "Server not found.");
                        logger.fine(m_className, method, "Process error Stream: " + errorBuffer.toString());
                    }
                    if (!processMonitor.isAlive()) {
                        try {
                            outputReader.join(1000L);
                            errorReader.join(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    result = new VWTaskProcessResult(!processMonitor.isAlive() ? process.exitValue() : -999, outputBuffer.toString(), errorBuffer.toString(), lookupResult);
                    try {
                        processMonitor.interrupt();
                    }
                    catch (Exception e) {}
                    break block26;
                }
                logger.fine(m_className, method, "Waiting for process to exit.");
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    outputReader.join(1000L);
                    errorReader.join(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                result = new VWTaskProcessResult(process.exitValue(), outputBuffer.toString(), errorBuffer.toString());
            }
            finally {
                try {
                    outputReader.shutdown();
                }
                catch (Exception e) {}
                try {
                    errorReader.shutdown();
                }
                catch (Exception e) {}
            }
        }
        logger.fine(m_className, method, "Process exit value: " + result.exitValue());
        logger.fine(m_className, method, "Process output stream: " + result.getOutput().trim());
        logger.fine(m_className, method, "Process error stream: " + result.getError().trim());
        return result;
    }

    private static boolean useServiceManager(VWTaskBaseNode node) {
        return node != null && node.inServiceMode() && !Boolean.getBoolean("TaskManager.ServiceManagerProcess");
    }

    private static IVWTaskServiceManager getServiceManager(VWTaskBaseNode node) throws Exception {
        String method = "getServiceManager";
        IVWTaskServiceManager svcmgr = null;
        long startTime = new Date().getTime();
        while (svcmgr == null) {
            try {
                svcmgr = VWTaskServiceManager.lookupServiceManager(node);
                svcmgr.ping();
            }
            catch (Exception ex) {
                String serviceName;
                if (new Date().getTime() - startTime < 30000L) {
                    logger.fine(m_className, method, "Retrying...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex1) {
                        // empty catch block
                    }
                    svcmgr = null;
                    continue;
                }
                if (svcmgr != null) {
                    logger.log(Level.FINE, m_className, method, "Exception while looking up Task Service Manager, found the service manager in registry but got exception on ping.", ex);
                } else {
                    logger.log(Level.FINE, m_className, method, "Exception while looking up Task Service Manager, it looks like the RMI registry is not running or the service manager is not bound.", ex);
                }
                logger.fine(m_className, method, "Taskman.properites: " + node.getPropertyFilePath());
                if (svcmgr != null) {
                    try {
                        svcmgr.ping();
                        logger.fine(m_className, method, "For some reason the second ping worked, returning IVWTaskServiceManager.");
                        return svcmgr;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    int port = Integer.parseInt(VWTaskServiceProperties.getInstance(node.getPropertyFilePath()).getProperty("TaskServiceManager.PreviousRegistryPort"));
                    logger.fine(m_className, method, "RMI Registry port: " + port);
                    String[] list = LocateRegistry.getRegistry("localhost", port).list();
                    if (list != null) {
                        logger.fine(m_className, method, "RMI registry contents:");
                        for (int i = 0; i < list.length; ++i) {
                            logger.fine(m_className, method, list[i]);
                        }
                    } else {
                        logger.fine(m_className, method, "The RMI registry is empty.");
                    }
                }
                catch (Exception ex2) {
                    logger.log(Level.FINE, m_className, method, "Unable to list the RMI registry contents.", ex2);
                }
                if (node == null) {
                    node = VWTaskCore.getInstance().getSelectedNode();
                }
                if ((serviceName = node.getServiceDisplayName()) == null) {
                    serviceName = new VWString("filenet.vw.apps.taskman.VWTaskProcessLauncher.DefaultServiceName", "Process Services Manager").toString();
                }
                throw new VWException("filenet.vw.apps.taskman.VWTaskProcessLauncher.VerifyThatTaskManagerIsRunning", "Unable to perform command.  Verify that the {0} service is running.", serviceName);
            }
        }
        return svcmgr;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   08 Oct 2008 21:36:14  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.27  $";
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            return;
        }
        BufferedReader fr = null;
        try {
            fr = new BufferedReader(new FileReader(new File(args[0])));
            StringBuffer buf = new StringBuffer();
            String line = null;
            while ((line = fr.readLine()) != null) {
                buf.append(line);
            }
            fr.close();
            fr = null;
            line = buf.toString();
            boolean wait = false;
            if (args.length > 1) {
                String sWait = args[1].trim().toLowerCase();
                wait = sWait.equals("wait") || sWait.equals("true");
            }
            System.out.println("Executing :\n" + line);
            VWTaskProcessResult result = VWTaskProcessLauncher.execImpl(line, null, wait);
            if (wait && result != null) {
                System.err.println("Error=" + result.getError());
                System.out.println("Output=" + result.getOutput());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fr != null) {
            fr.close();
        }
    }

    protected static class Util
    extends VWConvertTwo {
        protected Util() {
        }

        private String encodeCommand(String cmd) throws Exception {
            return super.getEString(cmd, "");
        }

        protected String getKey(int id) {
            return "MIIBCTCBtAIBADBPMQswCQYDeQQGEwJV6s4fUzEQMA4GA1UECBMHRmxvcmlkYTEYMBYGA1UEChMPRXllcyBvbiBUaGUgV2ViMRQwEgYDVQQDFAt3d3cuZXR3Lm5ldDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCeojtjnHqg0GTxp+XZ56RaSe1iZWpumXjU6Sx7v1FdXzsY1oLOQa090Jtnu1WsQRHh0yDS+45oncjKm1zCIZAgMBAAGgADANBgkqhkiG9w0BAQQFAANBAFBj9g+NiUh8YWPrFGntgf4miUdwqUshptjJy4PjdsD*3ugy5avvuh3GPpGh2aYXIjHpJXTUBQyzxSEIINYtc";
        }

        protected String getEString(String str1, String str2) throws Exception {
            return super.getEString(str1, str2);
        }
    }
}

